#include <iostream>
#include <algorithm>
using namespace std;


int indeks_prvog_pojavljivanja(long long int niz[], int n, long long int elem)
{
    int l = 0, d = n - 1;
    int resenje = -1;

    while (l <= d) {
        int s = l + (d - l + 1) / 2;
        long long int srednji = niz[s];

        if (srednji < elem)
            l = s + 1;
        else if (srednji > elem)
            d = s - 1;
        else {
            resenje = s;
            d = s - 1;
            }
        }
    return resenje;
}

int indeks_poslednjeg_pojavljivanja(long long int niz[], int n, long long int elem)
{
    int l = 0, d = n - 1;
    int resenje = -1;

    while (l <= d) {
        int s = l + (d - l + 1) / 2;
        long long int srednji = niz[s];

        if (srednji < elem)
            l = s + 1;
        else if (srednji > elem)
            d = s - 1;
        else {
            resenje = s;
            l = s + 1;
        }
    }
    return resenje;
}

int najveci_manji_od(long long int niz[], int n, long long int elem)
{
    int l = 0, d = n-1;
    int resenje = -1;

    while (l <= d) {
        int mid = l + (d - l + 1) / 2;
        long long int sredina = niz[mid];

        if (sredina < elem) {
            resenje = mid;
            l = mid + 1;
        } else if (sredina > elem) {
            d = mid - 1;
        } else {
            d = mid - 1;
        }
    }
    return resenje;
}



int zad_glasanje(long long int A[], int n, long long int B[], int m) {


    for (int m=0; m<n; m++)
        sort(A, A + n);

    long long int medijana = A[n / 2];

    for (int i=0; i < m; i++) {
        long long int X = B[i];

        if (medijana == X) {
            std::cout << 0 << std::endl;
            continue;
        }


        if (X > medijana) {
            int indeks = indeks_prvog_pojavljivanja(A, n, X);
            if (indeks != -1) {
                std::cout << 2*indeks-n << std::endl;
                continue;
            }
        } else {
            int indeks = indeks_poslednjeg_pojavljivanja(A, n, X);
            if (indeks != -1) {
                std::cout << (n-indeks-1)-indeks << std::endl;
                continue;
            }
        }


        int indeks = najveci_manji_od(A, n, X);

        indeks++;
        int indeks_nove_medijane = (n+1)/2;
        if (indeks == indeks_nove_medijane) {
            std::cout << 1 << std::endl;
            continue;
        }
        if (indeks > indeks_nove_medijane) {
            std::cout << 1 + 2*indeks-(n+1) << std::endl;
        } else {
            std::cout << 1 + (n+1-indeks-1)-indeks << std::endl;
        }
    }
}


int main() {
    int N, Q;
    std::cin >> N >> Q;

    long long int* A = new long long int[N];
    long long int* B = new long long int[Q];
    for (int i = 0; i < N; i++)
        std::cin >> A[i];
    for (int i=0; i < Q; i++)
        std::cin >> B[i];

    zad_glasanje(A, N, B, Q);

    delete[] A;
    delete[] B;

    return 0;
}